<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@lang('messages.booking_request.title')</title>
</head>

<body style="margin:0; padding:0; font-family: Arial, sans-serif; background-color:#ffffff;">
    <table align="center" width="100%" cellpadding="0" cellspacing="0" border="0" style="max-width:700px;">
        <!-- Email Banner -->
         <tr>
            <td align="center" valign="top">
              <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td align="center" valign="top" style=" width:100%; height:60px;">
                    
                    <!-- Spacer to push logo down -->
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" height="27">
                      <tr>
                        <td></td>
                      </tr>
                    </table>

                    <!-- Logo -->
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td align="center">
                          <img src="{{ asset('frontend/images/logo.png')}}" width="240" style="max-width:240px; width:100%; display:block; border:0;" alt="Logo">
                        </td>
                      </tr>
                    </table>

                  </td>
                </tr>
              </table>
            </td>
          </tr>

        <!-- Email Body -->
        <tr>
            <td style="padding:50px 30px; font-family:Arial, sans-serif;">
                <h2 style="font-family:Arial, sans-serif; font-weight:700; font-size:24px; line-height:100%; text-align:center; margin:0;">
                    @lang('messages.booking_request.booking_request')
                </h2>
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; text-align:center; margin:30px 0 30px 0; color:#111111;">
                    @lang('messages.booking_request.dear', ['title' => $title, 'first_name' => $first_name, 'last_name' => $last_name])<br>
                </p>
                <p style="font-family: Arial; font-weight: 400; font-size: 16px; line-height: 24px; color: #111111;">
                    @lang('messages.booking_request.thank_you_message')
                </p>

                <!-- Request Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b>@lang('messages.booking_request.request_details'):</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('messages.booking_request.request_id')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $booking_request_id }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('messages.booking_request.pickup_location')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $pickup_location }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('messages.booking_request.rental_period')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ \Carbon\Carbon::parse($rental_from)->format('d.m.Y') }} - {{ \Carbon\Carbon::parse($rental_to)->format('d.m.Y') }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('messages.booking_request.unavailable_components')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ ucwords($unavailable_components) }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('messages.booking_request.carrier_length')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $carrier_length }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('messages.booking_request.foot_sku')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $foot_sku }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('messages.booking_request.footkit_sku')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $footkit_sku }}
                        </td>
                    </tr>
                </table>

                <!-- Product Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b>@lang('messages.booking_request.product_details'):</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('messages.booking_request.product_name')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $product_name }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('messages.booking_request.quantity')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            1
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('messages.booking_request.size_variation')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $size_name }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('messages.booking_request.color')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $color_name }}
                        </td>
                    </tr>
                </table>

                <!-- Car Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b>@lang('messages.booking_request.car_details'):</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('messages.booking_request.brand')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $manufacturer }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('messages.booking_request.year')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $car_year }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('messages.booking_request.model')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $car_model }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('messages.booking_request.trailer_hitch')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $trailer_hitch ? ucwords($trailer_hitch) : '' }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('messages.booking_request.roof_type')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $roof_type ? ucwords($roof_type) : '' }}
                        </td>
                    </tr>
                </table>

                <!-- Customer Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b>@lang('messages.booking_request.customer_details'):</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('messages.booking_request.customer_name')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $first_name }} {{ $last_name }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('messages.booking_request.address')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $street }}, {{ $zipcode }} <br> {{ $city }}, <br> {{ $state }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('messages.booking_request.email_address')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $email }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('messages.booking_request.phone_number')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $phone }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('messages.booking_request.message')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $messages }}
                        </td>
                    </tr>
                </table>

                <!-- Closing Paragraph -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#000000; margin-top:30px;">
                    @lang('messages.booking_request.closing_message')<br><br>
                    @lang('messages.booking_request.best_regards')<br>
                    @lang('messages.booking_request.team_signature')
                </p>
            </td>
        </tr>

        <!-- Footer -->
        <tr>
            <td bgcolor="#111111" style="padding:31px 45px 81px; border-bottom:1px solid #383838;" align="center">
                <img src="{{ asset('frontend/images/logo.png')}}" alt="" width="220" style="display:block; margin:0 auto;">
                <p style="font-family:Arial; font-size:15px; line-height:24px; text-align:center; color:#ffffff; margin:20px 0;">
                    @lang('messages.booking_request.footer_help_text')
                </p>

                <!-- Social Section -->
                <table border="0" cellspacing="0" cellpadding="0" align="center">
                    <tr>
                        <td align="center" valign="top" style="padding:0 15px;">
                            <img src="{{ asset('frontend/images/Message.png')}}" width="20" height="20" style="display:block; margin:0 auto;">
                            <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:10px 0 0 0;">cs@dachboxit.de</p>
                        </td>
                        <td align="center" valign="top" style="padding:0 15px;">
                            <img src="{{ asset('frontend/images/Mobile.png')}}" width="20" height="20" style="display:block; margin:0 auto;">
                            <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:10px 0 0 0;">+4915172876293</p>
                        </td>
                    </tr>
                </table>

                <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:20px 0;">
                    <a href="http://49.249.236.30:3131/dachboxmiete-phase-2/public/gdpr" style="color:#ffffff; text-decoration:none; margin:0 5px;">
                        @lang('messages.booking_request.privacy_policy')
                    </a> 
                    | 
                    <a href="http://49.249.236.30:3131/dachboxmiete-phase-2/public/term-condition" style="color:#ffffff; text-decoration:none; margin:0 5px;">
                        @lang('messages.booking_request.terms_conditions')
                    </a>
                </p>

                <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:0;">
                    @lang('messages.booking_request.company_address')<br>@lang('messages.booking_request.tax_id')
                </p>
            </td>
        </tr>
        <!-- Copyright -->
        <tr>
            <td bgcolor="#111111" style="padding:15px 30px; text-align:center;">
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:14px; line-height:24px; color:#fff; margin:0;">
                    @lang('messages.booking_request.copyright', ['year' => date('Y')])
                </p>
            </td>
        </tr>
    </table>
</body>
</html>